{*************************************************************}
{                                                             }
{       Borland Delphi Visual Component Library               }
{       InterBase Express core components                     }
{                                                             }
{       Copyright (c) 1998-2005 Borland Software Corporation  }
{                                                             }
{    InterBase Express is based in part on the product        }
{    Free IB Components, written by Gregory H. Deatz for      }
{    Hoagland, Longo, Moran, Dunst & Doukas Company.          }
{    Free IB Components is used under license.                }
{                                                             }
{    Additional code created by Jeff Overcash and used        }
{    with permission.                                         }
{*************************************************************}

unit IBTransactionEdit;

interface

uses
{$IFDEF MSWINDOWS}
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls,
{$ENDIF}
{$IFDEF LINUX}
 Libc, SysUtils, Classes, QControls, QForms, QDialogs, QStdCtrls, QExtCtrls, {$ENDIF}
 IBDataBase, IB, IBXConst;

type
  TIBTransactionEditForm = class(TForm)
    GroupBox1: TGroupBox;
    HelpBtn: TButton;
    Cancelbtn: TButton;
    OKBtn: TButton;
    rbSnapShot: TRadioButton;
    rbReadCommitted: TRadioButton;
    rbReadOnlyTableStability: TRadioButton;
    rbReadWriteTableStability: TRadioButton;
    TransactionParams: TMemo;
    Panel1: TPanel;
    Label1: TLabel;
    rbPreCommitted: TRadioButton;
    chkReadOnly: TCheckBox;
    chkNoSavePoints: TCheckBox;
    procedure chkNoSavePointsClick(Sender: TObject);
    procedure chkReadOnlyClick(Sender: TObject);
    procedure rbPreCommittedClick(Sender: TObject);
    procedure OKBtnClick(Sender: TObject);
    procedure rbSnapShotClick(Sender: TObject);
    procedure rbReadCommittedClick(Sender: TObject);
    procedure rbReadOnlyTableStabilityClick(Sender: TObject);
    procedure rbReadWriteTableStabilityClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure HelpBtnClick(Sender: TObject);
    procedure TransactionParamsClick(Sender: TObject);
    procedure TransactionParamsExit(Sender: TObject);

  private
    { Private declarations }
    Transaction: TIBTransaction;
    function Edit: Boolean;
    procedure ParseParams;
    procedure ClearParamSelection;

  public
    { Public declarations }
  end;

function EditIBtransaction(Atransaction: TIBtransaction): Boolean;

implementation

{$IFDEF MSWINDOWS}
{$R *.dfm}
{$ENDIF}
{$IFDEF LINUX}
{$R *.xfm}
{$ENDIF}

uses
  LibHelp, IBDCLConst;

const
  SConcurrency = 'concurrency'; {do not localize}
  SReadCommitted = 'read_committed'; {do not localize}
  SRecVersion = 'rec_version'; {do not localize}
  SNoWait = 'nowait'; {do not localize}
  SRead = 'read'; {do not localize}
  SWrite = 'write'; {do not localize}
  SConsistancy = 'consistency'; {do not localize}
  SNoSavepoint = 'no_savepoint'; {do not localize}

function EditIBtransaction(ATransaction: TIBtransaction): Boolean;
begin
  with TIBtransactionEditForm.Create(Application) do
  try
    Transaction := ATransaction;
    Result := Edit;
  finally
    Free;
  end;
end;

function TIBtransactionEditForm.Edit: Boolean;
begin
  TransactionParams.Lines := Transaction.Params;
  ParseParams;
  Result := False;
  if ShowModal = mrOk then
  begin
    Transaction.Params := TransactionParams.Lines;
    Result := True;
  end;
end;

type
  TTransactionParam = (concurrency, read_committed, rec_version, nowait,
    consistency, read, write, no_savepoint);
  TTransactionParams = set of TTransactionParam;

procedure TIBTransactionEditForm.ParseParams;
var
  I: Integer;
  st: string;
  Value: TTransactionParams;

begin
  Value := [];
  for I := 0 to TransactionParams.Lines.Count - 1 do
  begin
    st := LowerCase(Trim(TransactionParams.Lines[I]));
    if st = '' then    {do not localize}
      continue;
    if st = SConcurrency then
      Include(Value, concurrency)
    else if st = SReadCommitted then
      Include(Value, read_committed)
    else if st = SRecVersion then
      Include(Value, rec_version)
    else if st = SNoWait then
      Include(Value, nowait)
    else if st = SRead then
      Include(Value, read)
    else if st = SWrite then
      Include(Value, write)
    else if st = SConsistancy then
      Include(Value, consistency)
    else if st = SNoSavepoint then
      Include(Value, no_savepoint)
    else begin
      Value := [];
      break;
    end;
  end;
  ClearParamSelection;
  if Value = [concurrency, nowait] then
    rbSnapShot.Checked := True
  else if Value = [read_committed, rec_version, nowait] then
    rbReadCommitted.Checked := True
  else if Value = [read, consistency] then
    rbReadOnlyTableStability.Checked := True
  else if Value = [write, consistency] then
    rbReadWriteTableStability.Checked := True
  else if Value = [read_committed, rec_version, nowait, read] then
    rbPreCommitted.Checked := True;
  chkNoSavePoints.Checked := (no_savepoint in Value);
  chkReadOnly.Checked := (read in Value);
end;

procedure TIBTransactionEditForm.ClearParamSelection;
begin
  rbSnapShot.Checked := False;
  rbReadCommitted.Checked := False;
  rbReadOnlyTableStability.Checked := False;
  rbReadWriteTableStability.Checked := False;
end;

procedure TIBTransactionEditForm.OKBtnClick(Sender: TObject);
begin
  ModalResult := mrNone;
  if Transaction.Active then
  begin
    if MessageDlg(SCommitTransaction, mtConfirmation,
      mbOkCancel, 0) <> mrOk then Exit;
    Transaction.Rollback;
  end;
  ModalResult := mrOk;
end;

procedure TIBTransactionEditForm.FormCreate(Sender: TObject);
begin
  HelpContext := hcDIBTransactionEdit;
end;

procedure TIBTransactionEditForm.HelpBtnClick(Sender: TObject);
begin
  try
    Application.HelpContext(HelpContext);
  except
    ShowMessage(SHelpNotFound);
  end;
end;

procedure TIBTransactionEditForm.rbSnapShotClick(Sender: TObject);
begin
  TransactionParams.clear;
  TransactionParams.Lines.Add(SConcurrency);
  TransactionParams.Lines.Add(SNoWait);
  chkReadOnly.Checked := false;
  chkNoSavePoints.Checked := false;
end;

procedure TIBTransactionEditForm.rbReadCommittedClick(Sender: TObject);
begin
  TransactionParams.clear;
  TransactionParams.Lines.Add(SReadCommitted);
  TransactionParams.Lines.Add(SRecVersion);
  TransactionParams.Lines.Add(SNoWait);
  chkReadOnly.Checked := false;
  chkNoSavePoints.Checked := false;
end;

procedure TIBTransactionEditForm.rbReadOnlyTableStabilityClick(Sender: TObject);
begin
  TransactionParams.clear;
  TransactionParams.Lines.Add(SRead);
  TransactionParams.Lines.Add(SConsistancy);
  chkReadOnly.Checked := true;
  chkNoSavePoints.Checked := false;
end;

procedure TIBTransactionEditForm.rbReadWriteTableStabilityClick(Sender: TObject);
begin
  TransactionParams.clear;
  TransactionParams.Lines.Add(SWrite);
  TransactionParams.Lines.Add(SConsistancy);
  chkReadOnly.Checked := false;
  chkNoSavePoints.Checked := false;
end;

procedure TIBTransactionEditForm.TransactionParamsClick(Sender: TObject);
begin
  ClearParamSelection;
end;

procedure TIBTransactionEditForm.TransactionParamsExit(Sender: TObject);
begin
  ParseParams;
end;

procedure TIBTransactionEditForm.rbPreCommittedClick(Sender: TObject);
begin
  TransactionParams.clear;
  TransactionParams.Lines.Add(SReadCommitted);
  TransactionParams.Lines.Add(SRecVersion);
  TransactionParams.Lines.Add(SNoWait);
  TransactionParams.Lines.Add(SRead);
  chkReadOnly.Checked := true;
  chkNoSavePoints.Checked := false;
end;

procedure TIBTransactionEditForm.chkReadOnlyClick(Sender: TObject);
begin
  if chkReadOnly.Checked then
  begin
    if TransactionParams.Lines.IndexOf(SRead) < 0 then
      TransactionParams.Lines.Add(SRead);
  end
  else
  begin
    if TransactionParams.Lines.IndexOf(SRead) >= 0 then
      TransactionParams.Lines.Delete(TransactionParams.Lines.IndexOf(SRead));
  end;
end;

procedure TIBTransactionEditForm.chkNoSavePointsClick(Sender: TObject);
begin
  if chkNoSavePoints.Checked then
  begin
    if TransactionParams.Lines.IndexOf(SNoSavepoint) < 0 then
      TransactionParams.Lines.Add(SNoSavepoint);
  end
  else
  begin
    if TransactionParams.Lines.IndexOf(SNoSavepoint) >= 0 then
      TransactionParams.Lines.Delete(TransactionParams.Lines.IndexOf(SNoSavepoint));
  end;
end;

end.
